﻿/*
 * Created by SharpDevelop.
 * User: tianhao shi
 * Date: 09/02/2016
 * Time: 14:57
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using WComp.Beans;
using SendEmailLibrary;


namespace WComp.Beans
{

	[Bean(Category="Perch")]
	public class SendMailBean
	{
		private String location = "";
		private String weather = "";
		private String userAddress = "";
		private String message = "";
		//private bool send = false;

		public String Location {
			get { return location;}
			set {
				if(value != null){
					location = value;
					LocationChanged(location);
				}
			}
		}
		
		public String Weather {
			get { return weather;}
			set {
				if(value != null){
					weather = value;
					WeatherChanged(weather);
					FireStringEvent(weather);
				}
			}
		}
		
		public String UserAddress {
			get { return userAddress;}
			set {
				if(value != null){
					userAddress = value;
					UserAddressChanged(userAddress);
				}
			}
		}
		
		public String Message {
			get { return message;}
		}
		
		/**
		public bool Send {
			get { return send; }
			set {
				send = value;
				SendChanged(send);
				FireBoolEvent(send);
			}
		}
		*/

		public delegate void StringValueEventHandler(String val);
		public delegate void BoolValueEventHandler(bool val);

		public event StringValueEventHandler LocationChanged;
		public event StringValueEventHandler WeatherChanged;
		public event StringValueEventHandler UserAddressChanged;
		public event StringValueEventHandler MessageChanged;
		public event BoolEventHandler SendChanged;
		
		private void FireStringEvent(String i) {
			if (location != "" && weather != "" && userAddress != "") {
				Email email = new Email();
				email.SetDestination(userAddress);

				message = String.Format("Dear {0}", userAddress) + "\r\n\r\n"
					+ "Your perch has taken a picture for you, here is the meta information:\r\n"
					+ "	Location\r\n"
					+ "	" + location + "\r\n\r\n"
					+ "	Weather\r\n"
					+ "	" + weather +  "\r\n\r\n";
				
				
				email.SetBody(message);
				email.SendEmail();
				location = "";
				weather = "";
				//send = false;
				MessageChanged(message);
			}
		}
	}
}
